---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.41
-- DDL creates tables
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- Date Created: September 27, 2000 MSW
-- Date Updated: October 18, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 092800 Added columns TITLE, ACTOR, DIRECTOR to MOVIE_DETAIL table
-- MSW 100200 Added column CALC_M11 per BWL request
-- MSW 100200 Added UNIQUE CONSTRAINT(UN_EVALUATION_USER_ID_PROD_ID) to EVALUATION table on columns USER_ID and PRODUCT_ID
-- MSW 100300 Added ERRORS Table to store exceptions
-- MSW 100300 Deleted USER_CLUSTER_DESC column from USER_CLUSTER table
-- MSW 100300 Deleted table REL_PRODUCT_CLUSTER_USER because USER_CLUSTER_PRODUCT_STAT caused it to be redundant 
-- MSW 100300 Added PRODUCT_CLUSTER_STAT Table
-- MSW 100300 Added USER_CLUSTER_STAT Table
-- MSW 100300 Added PRODUCT_STAT Table
-- MSW 100300 Added USER_STAT Table
-- MSW 100300 Added PRODUCT_CLUSTER_USER_STAT Table
-- MSW 100300 Renamed USER_CLUSTER_PRODUCT_STAT.TOTAL_OF_USER_SEEN_PROD  -> TOTAL_USER_SEEN
-- MSW 100300 Renamed USER_CLUSTER_PRODUCT_STAT.TOTAL_OF_USER_ASK_PROD   -> TOTAL_USER_EVAL
-- MSW 100300 Renamed USER_CLUSTER_PRODUCT_STAT.FRACTION_OF_UC_SEEN_PROD -> FRACTION_OF_UC_SEEN
-- MSW 100300 Renamed USER_CLUSTER_PRODUCT_STAT.FRACTION_OF_UC_ASK_PROD  -> FRACTION_OF_UC_EVAL
-- MSW 100300 Renamed PRODUCT_CLUSTER.PRODUCT_CLUSTER_ACTIVE to PRODUCT_CLUSTER.PRODUCT_CLUSTER_ACTIVE_IND
-- MSW 100300 Changed datatype of PRODUCT_CLUSTER.PRODUCT_CLUSTER_ACTIVE_IND from CHAR(1) to NUMBER(1)
-- MSW 100300 Added all_user_prod_comb view
-- MSW 100400 Renamed USER_CLUSTER_PRODUCT_STAT to PRODUCT_USER_CLUSTER_STAT
-- MSW 100400 Added Column NEW_ADDITION_IND to PRODUCT_STAT
-- MSW 100500 Added Column PRODUCT_WEIGHT to TABLE PRODUCT_STAT, 1/# of Product Clusters this product belongs to
-- MSW 100500 Added Column W_TOTAL_PROD_IN_PC to TABLE PRODUCT_CLUSTER_STAT, Weight sum of products in PC
-- MSW 100500 Added Column W_TOTAL_NEW_PROD_IN_PC to TABLE PRODUCT_CLUSTER_STAT, Weight sum of NEW products in PC
-- MSW 100500 Added Column W_TOTAL_OLD_PROD_IN_PC to TABLE PRODUCT_CLUSTER_STAT, Weight sum of OLD products in PC
-- MSW 100500 Added Column TOTAL_NEW_PROD_EVAL to USER_PRODUCT_CLUSTER_STAT
-- MSW 100500 Added Column AVG_NEW_PROD_EVAL to USER_PRODUCT_CLUSTER_STAT
-- MSW 100500 Added Column TOTAL_NEW_PROD_SEEN to USER_PRODUCT_CLUSTER_STAT
-- MSW 100500 Added Column FRACTION_OF_NEW_EVAL_SEEN to USER_PRODUCT_CLUSTER_STAT
-- MSW 100500 Added Column FRACTION_OF_PC_EVAL to USER_PRODUCT_CLUSTER_STAT
-- MSW 100500 Added Column TOTAL_NEW_PROD_IN_PC to TABLE PRODUCT_CLUSTER_STAT
-- MSW 100500 Added Column TOTAL_OLD_PROD_IN_PC to TABLE PRODUCT_CLUSTER_STAT
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
-- MSW 100900 Altered CONSTRAINT UN_EVALUATION_USER_ID_PROD_ID to use the alkindi_index tablespace
-- MSW 100900 Added Column PRODUCT_CLUSTER_ID to USER_UC_STAT to enhance query performance
-- AHW 100900 Renamed "STAT" table USER_CLUSTER_MEAN_DISTANCE to USER_UC_STAT
-- AHW 100900 Renamed all "STAT" columns that contained "TOTAL" to "TOT"
-- AHW 100900 Renamed all "STAT" columns that contained "W" to "WGT"
-- AHW 100900 Renamed all "STAT" table names that contained USER_CLUSTER to UC
-- AHW 100900 Renamed all "STAT" table names that contained PRODUCT_CLUSTER to PC
-- AHW 100900 Renamed all "STAT" table names that contained PRODUCT to PROD
-- AHW 100900 Renamed all "STAT" columns that contained PRODUCT to PROD (except foreign key references)
-- AHW 100900 Renamed all "STAT" columns that contained PRODUCT_CLUSTER to PC (except foreign key references)
-- AHW 100900 Renamed all "STAT" columns that contained USER_CLUSTER to UC (except foreign key references)
-- AHW 100900 Renamed "STAT" table USER_CLUSTER_DISTANCE to USER_PROD_UC_STAT
-- MSW 100900 Added Column PRODUCT_CLUSTER_ID to USER_PROD_UC_STAT to enhance query performance
-- MSW 100900 Added Column PRODUCT_CLUSTER_ID to PROD_UC_STAT to enhance query performance
-- MSW 100900 Added Column PRODUCT_CLUSTER_ID to UC_STAT to enhance query performance
-- MSW 100900 Added Columns for "OLD" product stats to USER_PC_STAT
-- MSW 101000 Added many columns to "STAT" tables
-- AHW 101000 Commented out columns CALC_M3, CALC_M4, CALC_M11 from USER_UC_STAT 
-- MSW 101000 Added Columns OMEGA_WGT_TOT_OLD_PROD_IN_PC, OMEGA_TOT_FRACTION_USER_SEEN to PC_STAT
-- AHW 101000 Renamed all "STAT" columns that contained FRACTION to FRN
-- AHW 101000 Added Columns OME_TOT_OLD_PROD_EVAL, OME_TOT_OLD_PROD_SEEN, OME_FRN_OF_OLD_EVAL_SEEN to to USER_PC_STAT
-- MSW 101000 Added Column SIGMA_SQUARED to PROD_UC_STAT
-- MSW 101000 Added Table EVALUATION_HISTORY
-- MSW 101100 Added Column PREDICTED_EVALUATION to RECOMMENDATION
-- MSW 101100 Removed Column UNINTERESTED_IND from RECOMMENDATION
-- MSW 101100 Added Column SCORING_FUNCTION_ID to RECOMMENDATION
-- AHW 101100 Added TABLE SCORING_FUNCTION to store descriptions of storing functions used in a recommendation
-- AHW 101100 Added TABLE USER_SF_STAT to store recommendation stats by user and scoring function
-- AHW 101100 Changed constraint format for all primary keys
-- MSW 101100 Added Columns SCORE1,SCORE2,SCORE3,SCORE4,SCORE5,SCORE6,SCORE7,SCORE8 to PROD_UC_STAT
-- AHW 101100 Added TABLE REL_CLUSTERABLE_PROD_CLUSTER
-- AHW 101100 Added Columns TOT_CLUSTERABLE_PROD_IN_PC, PCT_CLUSTERABLE_PROD_IN_PC to PC_STAT
-- AHW 101100 Added Table RECOMMENDATION_LOG to contain records flushed out from the RECOMMENDATION table
-- MSW 101100 Added Column PRODUCT_CLUSTER_ID to REL_USER_CLUSTER to enhance query performance for recommendations
-- MSW 101200 Removed Column PRODUCT_CLUSTER_ACTIVE_IND from PRODUCT_CLUSTER
-- MSW 101200 Added Column SCORING_FUNCTION_WEIGHT to TABLE SCORING_FUNCTION
-- MSW 101500 Removed Column PRODUCT_INDEX from REL_PRODUCT_CLUSTER
-- MSW 101500 Added Column USER_CLUSTER_INDEX to TABLE UC_STAT
-- MSW 101500 Added Column PRODUCT_INDEX to PROD_UC_STAT
-- MSW 101500 Added UNIQUE CONSTRAINT(UN_REL_USER_CLUSTER_PC_USER) to REL_PRODUCT_CLUSTER table on columns PRODUCT_CLUSTER_ID, USER_ID
-- MSW 101500 Removed Column PROD_EVAL_MEAN_BY_UC from PROD_UC_STAT, column was redundant because of column AVG_PROD_EVAL_BY_UC
-- MSW 101500 Added Column USER_CLUSTER_SUBGROUP_INDEX to TABLE REL_USER_CLUSTER
-- MSW 101500 Added TABLE EVAL_PARAMETER to contain tunable parameters for the evaluation package
-- MSW 101500 Added TABLE USER_DATA_STAT
-- MSW 101600 Added TABLE ALKINDEX_STAT
-- MSW 101600 Added TABLE PROD_PC_STAT
-- MSW 101600 Added Column FRN_BAD_REC to TABLE PC_STAT
---------------------------------------------------------------------------------------------------------
---------------------------------------------------------------------------------------------------------
-- MSW 101800 Added Column TOT_USER_IN_SG	to ALKINDEX_STAT
-- MSW 101800 Added table PRODUCT to contain a master list of product ids and their corresponding product type
-- MSW 101800 Added Column PRODUCT_TYPE_ID to PROD_STAT
-- MSW 101800 Added Column PRODUCT_TYPE_ID to PROD_PC_STAT
-- MSW 101800 Added Column PRODUCT_TYPE_ID to PROD_UC_STAT
-- MSW 101800 Added INDEX PROD_STAT_PROD_AVG_USER_EVAL ON PROD_STAT (PRODUCT_ID, AVG_USER_EVAL)
-- MSW 101800 Added INDEX USER_PC_STAT_USER_ID ON USER_PC_STAT (USER_ID)
-- MSW 101800 Added INDEX PROD_UC_STAT ON PROD_UC_STAT (PRODUCT_CLUSTER_ID, PRODUCT_ID, USER_CLUSTER_ID, AVG_PROD_EVAL_BY_UC, TOT_USER_SEEN)
-- MSW 101800 Added INDEX USER_DATA_STAT_USER_ID ON USER_DATA_STAT (USER_ID)
-- MSW 101800 Added INDEX PROD_PC_STAT ON PROD_PC_STAT (PRODUCT_ID, PRODUCT_TYPE_ID, PRODUCT_CLUSTER_ID, NEW_ADDITION_IND, TOT_USER_EVAL, FRN_USER_SEEN, TOT_USER_SEEN)
-- MSW 101800 ALTER TABLE PC_STAT CACHE;
-- MSW 101800 ALTER TABLE EVAL_PARAMETER CACHE;
-- MSW 101800 ALTER TABLE SCORING_FUNCTION CACHE;
-- MSW 101800 ALTER TABLE REL_CLUSTERABLE_PROD_CLUSTER CACHE;
-- MSW 101800 Added INDEX ALKINDEX_STAT_SG_UC_PC ON ALKINDEX_STAT (USER_CLUSTER_SUBGROUP_INDEX, USER_CLUSTER_ID, PRODUCT_CLUSTER_ID)
-- MSW 101900 Added CONSTRAINT UN_REL_CLUSTERABLE_PC UNIQUE (PRODUCT_ID, PRODUCT_CLUSTER_ID) on TABLE REL_CLUSTERABLE_PROD_CLUSTER
-- MSW 101900 Added CONSTRAINT UN_USER_PC_STAT_USER_ID_PC_ID UNIQUE (USER_ID, PRODUCT_CLUSTER_ID) on TABLE USER_PC_STAT
-- MSW 101900 Added CONSTRAINT UN_USER_DATA_STAT_USER_ID_PC_ID UNIQUE (PRODUCT_CLUSTER_ID, USER_ID) on TABLE USER_DATA_STAT
-- MSW 101900 Added CONSTRAINT UN_PROD_PC_STAT_PROD_ID_PC_ID UNIQUE (PRODUCT_CLUSTER_ID, PRODUCT_ID) on TABLE PROD_PC_STAT
-- MSW 101900 Added CONSTRAINT UN_PROD_UC_STAT_PROD_ID_UC_ID UNIQUE (USER_CLUSTER_ID, PRODUCT_ID) on TABLE PROD_UC_STAT
-- MSW 102000 Added COLUMN AVG_PROD_RATING_BY_UC to TABLE PROD_UC_STAT, This column is different than the other averages that we are calculating.  This average is the sum of all ratings (1-6) over all ratings.

---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG
---------------------------------------------------------------------------------------------------------


--------------------------------------------------------------------------------------------------------
-- BEGIN SCHEMA CREATION
---------------------------------------------------------------------------------------------------------

CREATE TABLE PRODUCT_TYPE (
PRODUCT_TYPE_ID			NUMBER(2),						-- movie, music or book
PRODUCT_TYPE_DESC			VARCHAR2(2000), 
CONSTRAINT PK_PRODUCT_TYPE PRIMARY KEY (PRODUCT_TYPE_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE PRODUCT_CATEGORY (							-- Genres
PRODUCT_CATEGORY_ID	 	NUMBER(3),
PRODUCT_TYPE_ID			NUMBER(2),
PRODUCT_CATEGORY_DESC		VARCHAR2(2000),
CONSTRAINT PK_PRODUCT_CATEGORY PRIMARY KEY (PRODUCT_CATEGORY_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE PRODUCT (
PRODUCT_ID				NUMBER(10),
PRODUCT_TYPE_ID			NUMBER(2),
CONSTRAINT PK_PRODUCT PRIMARY KEY (PRODUCT_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE MOVIE (									-- This table will change when PRODUCT data is obtained by Alkindi
PRODUCT_ID		 		NUMBER(10),
PRODUCT_TYPE_ID			NUMBER(2),
TITLE					VARCHAR2(2000),
MOVIE_DESC				VARCHAR2(2000),
ACTOR					VARCHAR2(2000),
DIRECTOR				VARCHAR2(2000),
CONSTRAINT PK_MOVIE PRIMARY KEY (PRODUCT_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE BOOK (									-- This table will change when PRODUCT data is obtained by Alkindi
PRODUCT_ID		 		NUMBER(10),		
PRODUCT_TYPE_ID			NUMBER(2),
BOOK_DESC				VARCHAR2(2000),
CONSTRAINT PK_BOOK PRIMARY KEY (PRODUCT_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE MUSIC (									-- This table will change when PRODUCT data is obtained by Alkindi
PRODUCT_ID				NUMBER(10),
PRODUCT_TYPE_ID			NUMBER(2),
MUSIC_DESC				VARCHAR2(2000),
CONSTRAINT PK_MUSIC PRIMARY KEY (PRODUCT_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE REL_PRODUCT_CATEGORY (							-- The relation between a product and its category
PRODUCT_ID	 			NUMBER(10),
PRODUCT_CATEGORY_ID 		NUMBER(3)
);

CREATE TABLE QUESTION (									-- Stores questions to ask users when they forget their password
QUESTION_ID				NUMBER(2),
QUESTION_DESC			VARCHAR2(2000),
CONSTRAINT PK_QUESTION PRIMARY KEY (QUESTION_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE USER_STATUS (								-- PRD147, Stores the descriptions for USER_STATUS, For example a USER_STATUS_ID of 4 means that the account is suspended.
USER_STATUS_ID			NUMBER(2),
USER_STATUS_DESC			VARCHAR2(2000),
CONSTRAINT PK_USER_STATUS PRIMARY KEY (USER_STATUS_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE USER_ID (									-- Master USER_ID table,  A user can give us evaluations on movies and not become a member
USER_ID 				NUMBER(10),
DATE_CREATED			DATE, 
CONSTRAINT PK_USER_ID PRIMARY KEY (USER_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE USER_DETAIL (								-- PRD210, PRD211, PRD212
USER_ID	 			NUMBER(10),
EMAIL					VARCHAR2(40)			UNIQUE,	-- PRD113
SCREENNAME				VARCHAR2(15),					-- PRD114, PRD120, PRD121, EMAIL from Sacha 9/18/00
PASSWORD				VARCHAR2(16), 					-- PRD115, PRD133
QUESTION1				NUMBER(2),						-- PRD117
ANSWER1				VARCHAR2(30),					-- PRD117, EMAIL from Sacha 9/18/00
QUESTION2				NUMBER(2),						-- PRD117
ANSWER2				VARCHAR2(30),					-- PRD117, EMAIL from Sacha 9/18/00
HOME_ZIP_CODE			VARCHAR2(10),					-- PRD142, EMAIL from Sacha 9/18/00
SEX_ID				NUMBER(1),						-- PRD143
BIRTHDATE				DATE,		 					-- PRD141
EDUCATION_ID			NUMBER(1),						-- PRD144, 5.29, Some High School, Graduated High School, Some College, Graduated College, Post-Graduate Degree
WEEKLY_ENT_EXP			NUMBER(5,0),					-- dollar weekly entertainment expense, EMAIL from Sacha 9/18/00
USER_STATUS_ID			NUMBER(2),						-- PRD146, PRD147, 1-6, user (default), member, dormant
ADVISOR_STATUS_ID			NUMBER(2),						-- PRD148, PRD149, 1-6, normal (default), suspended, dormant
CONSTRAINT PK_USER_DETAIL PRIMARY KEY (USER_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE USER_CATEGORY (								-- VERSION 0.2, Describes user categories
USER_CATEGORY_ID 			NUMBER(10),
USER_CATEGORY_DESC		VARCHAR2(2000), 
CONSTRAINT PK_USER_CATEGORY PRIMARY KEY (USER_CATEGORY_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE REL_USER_CATEGORY (							-- VERSION 0.2, A user can belong to more than one category.  REL_USER_CATEGORY stores that relation
USER_ID		 		NUMBER(10),
USER_CATEGORY_ID			NUMBER(10)
);

CREATE TABLE PRODUCT_CLUSTER (							-- Master product cluster table
PRODUCT_CLUSTER_ID 		NUMBER(10),
PRODUCT_CLUSTER_DESC 		VARCHAR2(2000),
CONSTRAINT PK_PRODUCT_CLUSTER PRIMARY KEY (PRODUCT_CLUSTER_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE REL_PRODUCT_CLUSTER (							-- Contains inactive products and their product_clusters.  These products can not be evaluated or offered to users as recommendations
PRODUCT_CLUSTER_ID 		NUMBER(10),
PRODUCT_ID	 			NUMBER(10)
);

-- MSW 101900 Unique constaint added.  A product should only exists in a PC once.

CREATE TABLE REL_CLUSTERABLE_PROD_CLUSTER (					-- Contains products that we can cluster, evaluate and recommend
PRODUCT_CLUSTER_ID 		NUMBER(10),
PRODUCT_INDEX 			NUMBER(10),
PRODUCT_ID	 			NUMBER(10),
CONSTRAINT UN_REL_CLUSTERABLE_PC UNIQUE (PRODUCT_ID, PRODUCT_CLUSTER_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE (INITIAL 200K NEXT 50k)
);

-- MSW 101800, This table should definitely be cached.  It is a relatively slim table and enough
-- memory should be made available so that it can be cached. 
-- We are querying from it to relate products to Product Clusters. 
-- The table is also not updated or inserted into on any regular basis.

ALTER TABLE REL_CLUSTERABLE_PROD_CLUSTER CACHE;

CREATE TABLE USER_CLUSTER (								-- Contains user cluster and its associated index within the product cluster.  The index will be used at a future time for soft clustering
USER_CLUSTER_ID		 	NUMBER(10),
USER_CLUSTER_INDEX	 	NUMBER(10),
PRODUCT_CLUSTER_ID		NUMBER(10),
CONSTRAINT PK_USER_CLUSTER PRIMARY KEY (USER_CLUSTER_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE REL_USER_CLUSTER (							-- Which users belong to which user cluster
USER_CLUSTER_ID	 		NUMBER(10),
USER_CLUSTER_SUBGROUP_INDEX	NUMBER(10),
PRODUCT_CLUSTER_ID		NUMBER(10),
USER_ID	 			NUMBER(10),
CONSTRAINT UN_REL_USER_CLUSTER_PC_USER UNIQUE (PRODUCT_CLUSTER_ID, USER_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE (INITIAL 200K NEXT 50k)
);

CREATE TABLE EVALUATION (								-- PRD196, stores the current evaluation of a product by a user and when it occured
USER_ID 				NUMBER(10),
PRODUCT_ID	 			NUMBER(10),
EVALUATION_SCALE_ID		NUMBER(1),		 				-- PRD78, 9 options, Strongly Dislike, Dislike, Somewhat Dislike, Somewhat Like, Like, Strongly Like, INTERESTed, Not INTERESTed, Don't Know
EVALUATION_TIMESTAMP		DATE,							-- EMAIL from Roger 9/21/00
CONSTRAINT UN_EVALUATION_USER_ID_PROD_ID UNIQUE (USER_ID, PRODUCT_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE (INITIAL 8K NEXT 6k)
);

CREATE TABLE EVALUATION_HISTORY (							-- Stores evaluations that the user has changed
USER_ID 				NUMBER(10),
PRODUCT_ID	 			NUMBER(10),
EVALUATION_SCALE_ID		NUMBER(1),
OLD_EVALUATION_TIMESTAMP	DATE,	
NEW_EVALUATION_TIMESTAMP	DATE
);

CREATE TABLE RECOMMENDATION (								-- Stores products that we have recommended to a user
USER_ID	 			NUMBER(10),
PRODUCT_ID	 			NUMBER(10),
PREDICTED_EVALUATION		NUMBER(3,2),
SCORING_FUNCTION_ID		NUMBER(1),
RECOMMENDATION_TIMESTAMP	DATE
);

CREATE TABLE RECOMMENDATION_LOG (							-- Stores old recommendations to users.  This table will be populated occasionally through a SP.  Records will be moved from evaluation to here.
USER_ID	 			NUMBER(10),
PRODUCT_ID	 			NUMBER(10),
PREDICTED_EVALUATION		NUMBER(1),
SCORING_FUNCTION_ID		NUMBER(1),
RECOMMENDATION_TIMESTAMP	DATE,
LOG_TIMESTAMP			DATE
);

CREATE TABLE CATEGORY_RULE (								-- Version 2.0, EMAIL from Sacha 9/19/00
PRODUCT_CATEGORY_ID		NUMBER(10),
USER_CATEGORY_ID			NUMBER(10),
CATEGORY_RULE_DESC		VARCHAR2(2000)
);

CREATE TABLE USER_MY_LIST (								-- PRD412
USER_ID	 			NUMBER(10),
PRODUCT_ID	 			NUMBER(10),						-- PRD413, PRD414, PRD415, Retrieve additional data from product table
DATE_ADDED	 			DATE							-- PRD518
);

CREATE TABLE USER_FRIEND_EMAIL (							-- PRD170
USER_ID	 			NUMBER(10),
FRIEND_EMAIL			VARCHAR2(40),
DATE_ADDED	 			DATE
);

CREATE TABLE OTHER_TYPE (
OTHER_TYPE_ID			NUMBER(2),
OTHER_TYPE_DESC			VARCHAR2(2000),
CONSTRAINT PK_OTHER_TYPE PRIMARY KEY (OTHER_TYPE_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE USER_OTHER_ENTRY (
USER_ID				NUMBER(10),
OTHER_TYPE_ID			NUMBER(2),
OTHER_VALUE				VARCHAR2(30),
OTHER_VALUE_INDEX			NUMBER(2)						-- Added by MSW 9/22/00
);

CREATE TABLE USER_PRODUCT_REVIEW (
USER_ID				NUMBER(10),
PRODUCT_ID				NUMBER(10),
PRODUCT_REVIEW			VARCHAR2(2000),
DATE_ADDED		 		DATE
);

CREATE TABLE SEX (									-- PRD143
SEX_ID				NUMBER(1), 		
SEX_DESC				VARCHAR2(6),					-- AHW100200 changed datatype length
CONSTRAINT PK_SEX PRIMARY KEY (SEX_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
); 

CREATE TABLE SCORING_FUNCTION(							-- Stores scoring functions and their weights.  Scoring functions are used to give products scores within user clusters
SCORING_FUNCTION_ID		NUMBER(1),
SCORING_FUNCTION_WEIGHT		NUMBER(4,3),
SCORING_FUNCTION_DESC		VARCHAR2(2000),
CONSTRAINT PK_SCORING_FUNCTION PRIMARY KEY (SCORING_FUNCTION_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

-- MSW 101800
ALTER TABLE SCORING_FUNCTION CACHE;

CREATE TABLE EVALUATION_SCALE (							-- PRD78, Lookup table for evaluation_scale_ids
EVALUATION_SCALE_ID		NUMBER(1), 				
EVALUATION_SCALE_DESC		VARCHAR2(2000), 
CONSTRAINT PK_EVALUATION_SCALE PRIMARY KEY (EVALUATION_SCALE_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE EDUCATION (								-- PRD144
EDUCATION_ID			NUMBER(2), 
EDUCATION_DESC			VARCHAR2(2000),
CONSTRAINT PK_EDUCATION PRIMARY KEY (EDUCATION_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE ADVISOR_STATUS (
ADVISOR_STATUS_ID			NUMBER(2), 		-- PRD148,PRD149
ADVISOR_STATUS_DESC		VARCHAR2(2000), 
CONSTRAINT PK_ADVISOR_STATUS PRIMARY KEY (ADVISOR_STATUS_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE PROFESSION_TYPE (							
PROFESSION_TYPE_ID		NUMBER(2), 
PROFESSION_TYPE_DESC		VARCHAR2(2000),
CONSTRAINT PK_PROFESSION_TYPE PRIMARY KEY (PROFESSION_TYPE_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
); 

CREATE TABLE PROFESSION (								-- PRD214, PRD215, PRD216
PROFESSION_ID 			NUMBER(3), 
PROFESSION_TYPE_ID		NUMBER(2),
PROFESSION_DESC			VARCHAR2(2000),
CONSTRAINT PK_PROFESSION PRIMARY KEY (PROFESSION_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
); 

CREATE TABLE LANGUAGE (
LANGUAGE_ID				NUMBER(2), 
LANGUAGE_DESC			VARCHAR2(2000),
CONSTRAINT PK_LANGUAGE PRIMARY KEY (LANGUAGE_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE SPORTS (
SPORTS_ID				NUMBER(2),
SPORTS_DESC				VARCHAR2(2000),
CONSTRAINT PK_SPORTS PRIMARY KEY (SPORTS_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE ACTIVITY (
ACTIVITY_ID 			NUMBER(2), 
ACTIVITY_DESC			VARCHAR2(2000),
CONSTRAINT PK_ACTIVITY PRIMARY KEY (ACTIVITY_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
); 

CREATE TABLE INTEREST (									-- PRD280
INTEREST_ID				NUMBER(2),
INTEREST_DESC 			VARCHAR2(2000),
CONSTRAINT PK_INTEREST PRIMARY KEY (INTEREST_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
); 

CREATE TABLE MOVIE_GENRE (								-- PRD314-PRD329
MOVIE_GENRE_ID			NUMBER(2), 
MOVIE_GENRE_DESC 			VARCHAR2(50), 	
CONSTRAINT PK_MOVIE_GENRE PRIMARY KEY (MOVIE_GENRE_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
); 

CREATE TABLE REL_USER_MOVIE_GENRE (
USER_ID 				NUMBER(10), 
MOVIE_GENRE_ID		 	NUMBER(10)
);

CREATE TABLE REL_USER_PROFESSION (							-- PRD214, PRD215, PRD216
USER_ID 				NUMBER(10), 
PROFESSION_ID		 	NUMBER(10)
);

CREATE TABLE REL_USER_LANGUAGE (
USER_ID 				NUMBER(10),
LANGUAGE_ID 			NUMBER(10)
); 

CREATE TABLE REL_USER_SPORTS (
USER_ID 				NUMBER(10),
SPORTS_ID				NUMBER(10)
); 	

CREATE TABLE REL_USER_ACTIVITY (
USER_ID 				NUMBER(10),
ACTIVITY_ID				NUMBER(10)
); 

CREATE TABLE REL_USER_INTEREST (
USER_ID 				NUMBER(10),
INTEREST_ID				NUMBER(10)
); 

-- Stats
-----------------------------------------------------------------------
CREATE TABLE PROD_STAT (
PRODUCT_ID 				NUMBER(10),
PRODUCT_TYPE_ID			NUMBER(2),
PROD_WEIGHT				NUMBER(5,4),					-- MSW 100500, 1/# of Product Clusters this product belongs to
TOT_USER_EVAL			NUMBER(10),						-- MSW 100300, # of times rated
TOT_USER_SEEN			NUMBER(10),						-- MSW 100300, # of times seen
FRN_USER_SEEN			NUMBER(7,6),					-- MSW 100300, percentage seen
AVG_USER_EVAL			NUMBER(7,6),					-- MSW 100300, Average Evaluation when seen
NEW_ADDITION_IND			NUMBER(1),						-- MSW 100400, Indicator whether a product is old (0) or new (1)				
CONSTRAINT PK_PROD_STAT PRIMARY KEY (PRODUCT_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

-- MSW 101800, A specific AVG_USER_EVAL for a product is often queried in the RECOMMENDATION package
	CREATE INDEX PROD_STAT_PROD_AVG_USER_EVAL
	    ON PROD_STAT (PRODUCT_ID, AVG_USER_EVAL)
  TABLESPACE alkindi_index STORAGE (initial 500K NEXT 500K PCTINCREASE 0);

CREATE TABLE USER_STAT (
USER_ID 				NUMBER(10),
TOT_PROD_EVAL			NUMBER(10),						-- MSW 100300, # of Products Evaluated
AVG_PROD_EVAL			NUMBER(7,6),					-- MSW 100300, Rave (user's average rating in overall space)
TOT_PROD_SEEN			NUMBER(10),						-- MSW 100300, # of Products seen that were evaluated
FRN_PROD_SEEN			NUMBER(7,6),					-- MSW 100300, Eave (overall fraction of movies the user has seen out of those the user has been asked)
CONSTRAINT PK_USER_STAT PRIMARY KEY (USER_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE PC_STAT (
PRODUCT_CLUSTER_ID 		NUMBER(10),
TOT_PROD_IN_PC			NUMBER(10),						-- MSW 100300, ni: sum of movies in PC
TOT_CLUSTERABLE_PROD_IN_PC	NUMBER(10),						-- AHW 101100, BK Request by E-mail
FRN_CLUSTERABLE_PROD_IN_PC	NUMBER(7,6),					-- AHW 101100, BK Request by E-mail
TOT_NEW_PROD_IN_PC		NUMBER(10),						-- MSW 100500, sum of NEW products in PC
TOT_OLD_PROD_IN_PC		NUMBER(10),						-- MSW 100500, sum of OLD products in PC
WGT_TOT_PROD_IN_PC		NUMBER(14,4),					-- MSW 100500, Weight sum of products in PC
WGT_TOT_NEW_PROD_IN_PC		NUMBER(14,4),					-- MSW 100500, Weight sum of NEW products in PC
WGT_TOT_OLD_PROD_IN_PC		NUMBER(14,4),					-- MSW 100500, Weight sum of OLD products in PC
OME_WGT_TOT_OLD_PROD_IN_PC	NUMBER(14,4),					-- MSW 100500, Weight sum of OLD products in PC
OME_TOT_OLD_FRN_USER_SEEN	NUMBER(7,6),
FRN_BAD_REC				NUMBER(7,6),
CONSTRAINT PK_PC_STAT PRIMARY KEY (PRODUCT_CLUSTER_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

-- MSW 101800, Very small table, but accessed often.
ALTER TABLE PC_STAT CACHE;

CREATE TABLE UC_STAT (
USER_CLUSTER_ID 			NUMBER(10),
USER_CLUSTER_INDEX	 	NUMBER(10),
PRODUCT_CLUSTER_ID		NUMBER(10),
TOT_USER_IN_UC			NUMBER(10),						-- MSW 100300
CONSTRAINT PK_UC_STAT PRIMARY KEY (USER_CLUSTER_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE  (INITIAL 8K NEXT 6k)
);

CREATE TABLE USER_PC_STAT (
USER_ID 				NUMBER(10),
PRODUCT_CLUSTER_ID		NUMBER(10),
TOT_PROD_EVAL			NUMBER(10),						-- MSW 100300,
FRN_OF_PC_EVAL			NUMBER(7,6),					-- MSW 100500, Fraction of PC Evaluated
TOT_PROD_SEEN			NUMBER(10),						-- MSW 100300,
AVG_PROD_EVAL			NUMBER(7,6),					-- MSW 100300, Ri (user 's average rating in the i-th cluster)
FRN_OF_EVAL_SEEN			NUMBER(7,6),					-- MSW 100300, Ei (fraction of movie in the i-th movie cluster that the user has seen out of those the user has been asked)
TOT_NEW_PROD_EVAL			NUMBER(10),						-- MSW 100500
TOT_NEW_PROD_SEEN			NUMBER(10),						-- MSW 100500
AVG_NEW_PROD_EVAL			NUMBER(7,6),					-- MSW 100500
FRN_OF_NEW_EVAL_SEEN		NUMBER(7,6),					-- MSW 100500
TOT_OLD_PROD_EVAL			NUMBER(10),						-- MSW 100900
TOT_OLD_PROD_SEEN			NUMBER(10),						-- MSW 100900
AVG_OLD_PROD_EVAL			NUMBER(7,6),					-- MSW 100900
FRN_OF_OLD_EVAL_SEEN		NUMBER(7,6),					-- MSW 100900
OME_TOT_OLD_PROD_EVAL		NUMBER(10),						-- MSW 101000
OME_TOT_OLD_PROD_SEEN		NUMBER(10),						-- MSW 101000
OME_FRN_OF_OLD_EVAL_SEEN	NUMBER(7,6),					-- MSW 101000
CONSTRAINT UN_USER_PC_STAT_USER_ID_PC_ID UNIQUE (USER_ID, PRODUCT_CLUSTER_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE (INITIAL 200K NEXT 50k)
);

-- MSW 101800 selects are most often done strictly on USER_ID
	CREATE INDEX USER_PC_STAT_USER_ID
	    ON USER_PC_STAT (USER_ID)
  TABLESPACE alkindi_index STORAGE (initial 500K NEXT 500K PCTINCREASE 0);


CREATE TABLE PROD_UC_STAT (
PRODUCT_ID				NUMBER(10),
PRODUCT_TYPE_ID			NUMBER(2),
PRODUCT_INDEX			NUMBER(10),
USER_CLUSTER_ID		 	NUMBER(10),
USER_CLUSTER_INDEX	 	NUMBER(10),
PRODUCT_CLUSTER_ID		NUMBER(10),
PROD_EVAL_VARIANCE_BY_UC	NUMBER(8,6),
TOT_USER_EVAL			NUMBER(10),						-- MSW 092500 for Recommendation
TOT_USER_SEEN			NUMBER(10),						-- MSW 092500 for Recommendation
AVG_PROD_EVAL_BY_UC		NUMBER(7,6),					-- MSW 100500
AVG_PROD_RATING_BY_UC		NUMBER(7,6),					-- MSW 102000, This column is different than the other averages that we are calculating.  This average is the sum of ratings (1-6) over all evaluations.
FRN_OF_UC_SEEN			NUMBER(7,6),
FRN_OF_UC_EVAL			NUMBER(7,6),
SCORE1				NUMBER(13,3),
SCORE2				NUMBER(13,3),
SCORE3				NUMBER(13,3),
SCORE4				NUMBER(13,3),
SCORE5				NUMBER(13,3),
SCORE6				NUMBER(13,3),
SCORE7				NUMBER(13,3),
SCORE8				NUMBER(13,3),
SIGMA_SQUARED			NUMBER(8,6),
V					NUMBER(8,6),
AVG_V_BY_PC				NUMBER(8,6),
CONSTRAINT UN_PROD_UC_STAT_PROD_ID_UC_ID UNIQUE (USER_CLUSTER_ID, PRODUCT_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE (INITIAL 200K NEXT 50k)
);

-- MSW 101800
	CREATE INDEX PROD_UC_STAT
	    ON PROD_UC_STAT (PRODUCT_CLUSTER_ID, PRODUCT_ID, USER_CLUSTER_ID, AVG_PROD_EVAL_BY_UC, TOT_USER_SEEN)
  TABLESPACE alkindi_index STORAGE (initial 500K NEXT 500K PCTINCREASE 0);

CREATE TABLE USER_DATA_STAT (
USER_ID				NUMBER(10),
PRODUCT_CLUSTER_ID		NUMBER(10),
NI					NUMBER(14,4),
RI					NUMBER(7,6),
EI					NUMBER(7,6),
FI					NUMBER(7,6),
BI					NUMBER(7,6),
EAVE					NUMBER(7,6),
RAVE					NUMBER(7,6),
NEW_PROD_EPI			NUMBER(14,4),
NEW_PROD_NI				NUMBER(14,4),
NEW_PROD_EI				NUMBER(7,6),
NEW_PROD_MI				NUMBER(10),
OLD_PROD_OME_EPI			NUMBER(14,4),
OLD_PROD_OME_NI			NUMBER(14,4),
OLD_PROD_OME_EI			NUMBER(7,6),
OLD_PROD_OME_MI			NUMBER(10),
CONSTRAINT UN_USER_DATA_STAT_USER_PC UNIQUE (PRODUCT_CLUSTER_ID, USER_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE (INITIAL 200K NEXT 50k)
);

-- MSW 101800
	CREATE INDEX USER_DATA_STAT_USER_ID
	    ON USER_DATA_STAT (USER_ID)
  TABLESPACE alkindi_index STORAGE (initial 500K NEXT 500K PCTINCREASE 0);

CREATE TABLE PROD_PC_STAT (
PRODUCT_ID				NUMBER(10),
PRODUCT_TYPE_ID			NUMBER(2),
PRODUCT_CLUSTER_ID		NUMBER(10),
TOT_USER_SEEN			NUMBER(10),
TOT_USER_EVAL			NUMBER(10),
FRN_USER_SEEN			NUMBER(7,6),
AVG_USER_EVAL			NUMBER(7,6),
NEW_ADDITION_IND			NUMBER(1),
AVG_V					NUMBER(8,6),
CONSTRAINT UN_PROD_PC_STAT_PROD_ID_PC_ID UNIQUE (PRODUCT_CLUSTER_ID, PRODUCT_ID)
USING INDEX PCTFREE 20 TABLESPACE alkindi_index STORAGE (INITIAL 200K NEXT 50k)
);

-- MSW 101800
	CREATE INDEX PROD_PC_STAT
	    ON PROD_PC_STAT (PRODUCT_ID, PRODUCT_TYPE_ID, PRODUCT_CLUSTER_ID, NEW_ADDITION_IND, TOT_USER_EVAL, FRN_USER_SEEN, TOT_USER_SEEN)
  TABLESPACE alkindi_index STORAGE (initial 500K NEXT 500K PCTINCREASE 0);

-- Not sure if we store (Om 9/22/00)
CREATE TABLE USER_UC_STAT (
USER_ID				NUMBER(10),
USER_CLUSTER_ID		 	NUMBER(10),
PRODUCT_CLUSTER_ID		NUMBER(10),
MEAN_DISTANCE			NUMBER(8,6),
CALC_M1				NUMBER(6,3),					-- BK  092400 Added, MSW	Changed precision from 3,2 to 6,3
CALC_M2				NUMBER(14,6)					-- BK  092400 Added, MSW	Changed precision from 3,2 to 6,3
--CALC_M3				NUMBER(6,3),					-- MSW 101000 Commented out for BWL, BK  092400 Added, MSW	Changed precision from 3,2 to 6,3
--CALC_M4				NUMBER(6,3),					-- MSW 101000 Commented out for BWL, BK  092400 Added, MSW	Changed precision from 3,2 to 6,3
--CALC_M11				NUMBER(6,3)						-- MSW 101000 Commented out for BWL, MSW 100200 Added for BWL
);

-- Not sure if we store (Om 9/22/00)
CREATE TABLE USER_PROD_UC_STAT (							-- Version 2.0, Could be used for soft clustering
USER_ID				NUMBER(10),
PRODUCT_ID				NUMBER(10),
USER_CLUSTER_ID		 	NUMBER(10),
PRODUCT_CLUSTER_ID		NUMBER(10),
USER_CLUSTER_VMEAN_DISTANCE	NUMBER(8,6)
);

-- Not sure if we store (Om 9/22/00)
CREATE TABLE INTERCLUSTER_DISTANCE (						-- Version 2.0, Could be used for soft clustering
USER_CLUSTER_ID1		 	NUMBER(10),
USER_CLUSTER_ID2		 	NUMBER(10),
INTERCLUSTER_DISTANCE		NUMBER(8,6)
);

CREATE TABLE USER_SF_STAT (
USER_ID			 	NUMBER(10),
SCORING_FUNCTION_ID		NUMBER(1),
TOT_REC				NUMBER(4),
TOT_INT				NUMBER(3),
TOT_NOT_INT				NUMBER(3),
TOT_NOT_KNO				NUMBER(3)
);

CREATE TABLE EVAL_PARAMETER (								-- Tunable parameters for Eugene, contains "T" and "E"
TOT_EVAL_BY_USER_PC_PARA	NUMBER(10),
FRN_SEEN_BY_PC_PARA		NUMBER(7,6)
);

ALTER TABLE EVAL_PARAMETER CACHE;

CREATE TABLE ALKINDEX_STAT (
PRODUCT_CLUSTER_ID		NUMBER(10),
USER_CLUSTER_ID			NUMBER(10),
USER_CLUSTER_SUBGROUP_INDEX	NUMBER(10),
TOT_USER_IN_SG			NUMBER(10),
BI					NUMBER(7,6),
NI					NUMBER(14,4),
BBI					NUMBER(7,6)
);

	CREATE INDEX ALKINDEX_STAT_SG_UC_PC
	    ON ALKINDEX_STAT (USER_CLUSTER_SUBGROUP_INDEX, USER_CLUSTER_ID, PRODUCT_CLUSTER_ID)
  TABLESPACE alkindi_index STORAGE (initial 500K NEXT 500K PCTINCREASE 0);


CREATE TABLE ERRORS (									-- MSW 100300 Stores Exceptions
ERROR_ID				NUMBER(3),
ERROR_MESSAGE			VARCHAR2(512)
);


CREATE OR REPLACE VIEW all_user_prod_comb AS SELECT DISTINCT USER_ID.USER_ID, REL_CLUSTERABLE_PROD_CLUSTER.PRODUCT_ID FROM USER_ID, REL_CLUSTERABLE_PROD_CLUSTER;

---------------------------------------------------------------------------------------------------------
-- END SCHEMA CREATION
---------------------------------------------------------------------------------------------------------

